@extends('layouts.app')
@section('head')
@endsection
@section('content')
    <section class="page-404-content pt-lg pb-lg">
        <div class="container">
            <div class="row y-gap-30 justify-between items-center">
                <div class="col-lg-6">
                    <svg viewBox="0 0 629 481" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M578.913 175.247H554.912V263.571H578.913V175.247Z" fill="#F76652"/>
                        <path d="M575.339 183.85H558.455V240.083H575.339V183.85Z" fill="#FAFDFF"/>
                        <path d="M570.065 254.129C571.809 252.386 571.809 249.558 570.065 247.815C568.321 246.071 565.493 246.071 563.748 247.815C562.004 249.558 562.004 252.386 563.748 254.129C565.493 255.873 568.321 255.873 570.065 254.129Z" fill="#2E3D63"/>
                        <path d="M601.889 174.076L578.07 177.027L588.937 264.679L612.756 261.728L601.889 174.076Z" fill="#F76652"/>
                        <path d="M599.391 183.028L582.635 185.104L589.554 240.909L606.309 238.833L599.391 183.028Z" fill="#FAFDFF"/>
                        <path d="M602.785 253.462C604.292 251.51 603.932 248.706 601.979 247.199C600.026 245.692 597.222 246.053 595.714 248.005C594.206 249.957 594.567 252.761 596.52 254.268C598.472 255.775 601.277 255.414 602.785 253.462Z" fill="#2E3D63"/>
                        <path d="M264.011 275.657C259.396 252.913 241.38 163.905 235.693 136.072C234.71 131.19 230.392 127.677 225.419 127.677L139.391 127.588L169.377 285.153C170.866 292.893 175.273 299.799 181.705 304.353C186.767 307.955 192.812 309.92 199.036 310.009L264.011 310.813V275.657Z" fill="#475577"/>
                        <path d="M340.72 315.368H197.577C188.644 315.368 179.979 312.212 173.1 306.497C166.251 300.781 161.635 292.863 160.087 284.17L133.972 134.048C133.436 130.982 135.49 128.064 138.558 127.558C141.625 127.022 144.543 129.076 145.049 132.142L171.164 282.265C172.236 288.308 175.482 293.875 180.306 297.894C185.16 301.942 191.294 304.145 197.577 304.145H340.75C343.847 304.145 346.378 306.675 346.378 309.771C346.348 312.867 343.847 315.368 340.72 315.368Z" fill="#727B91"/>
                        <path d="M384.554 481C484.414 481 565.366 477.361 565.366 472.873C565.366 468.385 484.414 464.746 384.554 464.746C284.694 464.746 203.742 468.385 203.742 472.873C203.742 477.361 284.694 481 384.554 481Z" fill="#E1E7F7"/>
                        <path d="M383.569 429.299L362.242 434.222L368.594 461.72L389.92 456.797L383.569 429.299Z" fill="#FFCBBB"/>
                        <path d="M362.189 434.234L364.572 444.504L384.434 433.132L383.54 429.322L362.189 434.234Z" fill="#F6AF9B"/>
                        <path d="M401.943 452.809C401.347 452.809 400.811 452.69 400.335 452.392L400.156 452.273L400.216 452.065C401.198 448.403 403.938 445.159 406.052 443.105C406.946 442.212 409.268 440.306 411.383 441.348C412.991 442.152 413.378 444.385 412.723 445.933C412.067 447.54 410.638 448.612 409.328 449.475L408.941 449.713C407.065 450.934 404.206 452.809 401.943 452.809ZM400.871 451.976C402.926 452.928 406.618 450.517 408.643 449.207L409.03 448.969C410.251 448.165 411.591 447.153 412.216 445.694C412.752 444.385 412.455 442.539 411.144 441.884C409.387 440.991 407.333 442.747 406.529 443.521C404.444 445.486 401.854 448.552 400.871 451.976Z" fill="#350453"/>
                        <path d="M400.216 453.285L400.097 453.077C398.161 449.832 397.774 445.605 397.744 442.628C397.744 441.378 397.982 438.371 400.216 437.597C401.913 437.002 403.759 438.282 404.444 439.83C405.129 441.438 404.921 443.194 404.593 444.742L404.504 445.188C403.968 447.927 403.074 452.541 400.424 453.226L400.216 453.285ZM401.109 438.074C400.871 438.074 400.662 438.103 400.424 438.193C398.578 438.818 398.37 441.527 398.37 442.658C398.37 445.486 398.757 449.475 400.514 452.601C402.628 451.797 403.491 447.481 403.938 445.099L404.027 444.653C404.325 443.224 404.534 441.557 403.908 440.098C403.432 439.026 402.3 438.074 401.109 438.074Z" fill="#350453"/>
                        <path d="M426.271 458.525L401.585 452.452C397.922 451.559 394.527 449.564 391.788 446.707L387.589 442.36C387.589 442.36 382.706 446.528 384.046 454.655C384.82 459.418 371.42 460.4 367.876 458.852C367.876 458.852 367.846 458.852 367.787 458.882C366.655 459.418 366.06 460.698 366.357 461.918L368.829 472.575C369.067 473.558 370.02 474.153 371.003 473.945L426.39 461.174C427.611 460.817 427.551 458.852 426.271 458.525Z" fill="#2E3D63"/>
                        <path d="M371.956 470.254C371.807 470.254 371.688 470.164 371.658 470.015C371.628 469.867 371.718 469.688 371.896 469.658L419.809 458.584C419.958 458.554 420.136 458.644 420.166 458.822C420.196 458.971 420.107 459.15 419.928 459.18L372.015 470.254C371.986 470.254 371.956 470.254 371.956 470.254Z" fill="white"/>
                        <path d="M398.249 462.037C398.22 462.037 398.219 462.037 398.19 462.037C394.08 461.323 390.358 458.376 388.72 454.565C387.499 451.737 387.41 448.374 388.452 445.367C388.512 445.218 388.691 445.129 388.84 445.188C388.988 445.248 389.078 445.426 389.018 445.575C388.035 448.433 388.125 451.648 389.286 454.327C390.835 457.989 394.378 460.757 398.279 461.442C398.428 461.472 398.547 461.621 398.517 461.799C398.517 461.948 398.398 462.037 398.249 462.037Z" fill="white"/>
                        <path d="M285.721 433.311H263.834V461.531H285.721V433.311Z" fill="#FFCBBB"/>
                        <path d="M263.834 433.311V443.849L285.751 437.24V433.311H263.834Z" fill="#F6AF9B"/>
                        <path d="M299.567 460.46C298.524 460.46 297.572 460.221 296.916 459.596L296.768 459.448L296.887 459.239C298.673 455.905 302.068 453.345 304.599 451.827C305.671 451.172 308.351 449.802 310.168 451.321C311.537 452.482 311.418 454.714 310.436 456.084C309.423 457.513 307.785 458.227 306.326 458.763L305.909 458.912C304.272 459.507 301.681 460.46 299.567 460.46ZM297.512 459.328C299.299 460.728 303.438 459.209 305.701 458.376L306.118 458.227C307.488 457.721 309.036 457.036 309.929 455.756C310.763 454.595 310.882 452.72 309.751 451.797C308.232 450.547 305.85 451.767 304.867 452.363C302.485 453.791 299.269 456.203 297.512 459.328Z" fill="#350453"/>
                        <path d="M296.619 460.43L296.559 460.221C295.398 456.619 295.964 452.422 296.619 449.505C296.887 448.284 297.81 445.397 300.133 445.159C301.919 444.95 303.438 446.617 303.736 448.284C304.034 449.981 303.438 451.678 302.783 453.107L302.604 453.524C301.532 455.905 299.537 460.37 296.827 460.43H296.619ZM300.43 445.754C300.371 445.754 300.282 445.754 300.222 445.754C298.257 445.962 297.482 448.522 297.214 449.624C296.589 452.392 296.053 456.352 297.066 459.775C299.299 459.477 301.115 455.429 302.098 453.256L302.277 452.839C302.872 451.499 303.468 449.922 303.17 448.374C302.932 447.093 301.77 445.754 300.43 445.754Z" fill="#350453"/>
                        <path d="M320.828 471.414L298.138 459.924C294.773 458.227 291.914 455.518 289.859 452.125L286.762 446.945C286.762 446.945 281.075 449.922 280.539 458.138C280.211 462.93 266.93 460.906 263.863 458.584C263.863 458.584 263.833 458.584 263.774 458.584C262.553 458.852 261.689 459.954 261.689 461.234V472.159C261.689 473.171 262.493 473.975 263.506 473.975H320.352C321.603 473.945 321.99 472.01 320.828 471.414Z" fill="#2E3D63"/>
                        <path d="M314.485 470.611H265.292C265.113 470.611 264.994 470.462 264.994 470.313C264.994 470.134 265.143 470.015 265.292 470.015H314.485C314.664 470.015 314.783 470.164 314.783 470.313C314.783 470.492 314.634 470.611 314.485 470.611Z" fill="white"/>
                        <path d="M292.777 468.527C292.747 468.527 292.688 468.527 292.658 468.497C288.816 466.89 285.868 463.169 285.124 459.09C284.588 456.054 285.243 452.75 286.94 450.07C287.03 449.922 287.208 449.892 287.357 449.981C287.506 450.07 287.536 450.249 287.447 450.398C285.839 452.958 285.213 456.113 285.72 459.001C286.434 462.901 289.233 466.413 292.896 467.961C293.045 468.021 293.134 468.2 293.045 468.348C293.015 468.467 292.896 468.527 292.777 468.527Z" fill="white"/>
                        <path d="M359.36 249.907C353.464 255.89 343.548 255.057 335.657 252.02C335.478 251.961 335.27 251.872 335.091 251.812C322.168 246.632 311.18 236.838 304.509 224.663C304.36 224.395 304.212 224.127 304.063 223.859C298.822 213.917 288.727 165.096 312.43 170.484C321.691 172.598 331.429 185.101 337.474 191.828C345.275 200.521 352.124 210.106 357.812 220.317C360.403 224.961 362.785 229.843 363.499 235.112C364.214 240.381 363.083 246.096 359.36 249.907Z" fill="#FFCBBB"/>
                        <path d="M335.658 252.02C335.479 251.961 335.27 251.872 335.092 251.812C322.168 246.632 311.18 236.838 304.51 224.663C305.254 224.425 305.999 224.187 306.654 223.919C311.269 222.014 315.915 220.079 320.53 218.174C320.709 230.855 326.397 243.328 335.658 252.02Z" fill="#F6AF9B"/>
                        <path d="M290.992 169.115H247.873L251.476 158.22C252.31 155.66 254.722 153.933 257.402 153.933H281.492C284.202 153.933 286.584 155.66 287.418 158.22L290.992 169.115Z" fill="#B9B5B2"/>
                        <path d="M314.336 271.102C297.928 287.504 221.518 271.102 221.518 271.102L228.992 208.737L221.369 169.859C221.369 164.412 225.806 159.976 231.255 159.976H304.301C309.75 159.976 314.187 164.412 314.187 169.859C314.157 169.829 332.203 253.181 314.336 271.102Z" fill="#B9B5B2"/>
                        <path d="M388.753 429.798L360.672 437.449C357.307 438.371 353.883 436.228 353.198 432.805L328.006 305.693H294.148C271.487 305.098 261.869 292.684 261.869 279.854L258.266 267.232C257.849 266.815 322.467 264.285 349.356 265.297C360.464 265.714 369.814 273.722 371.958 284.617L393.1 422.832C393.666 425.928 391.79 428.965 388.753 429.798Z" fill="#FCA32D"/>
                        <path d="M255.496 305.782H328.333L255.496 291.345V305.782Z" fill="#EF8E18"/>
                        <path d="M295.517 282.384V429.5C295.517 432.805 292.837 435.514 289.502 435.514H260.051C256.716 435.514 254.036 432.835 254.036 429.5L252.964 407.591L248.021 305.693H227.385C224.913 305.634 222.62 305.425 220.447 305.098C202.729 302.389 195.105 291.315 195.105 279.854L204.128 263.035C203.682 262.588 252.756 264.404 279.169 265.416C288.311 265.744 295.517 273.245 295.517 282.384Z" fill="#FFB548"/>
                        <path d="M282.981 378.15C282.803 378.15 282.684 378.001 282.684 377.852L285.006 289.231C285.006 281.729 279.914 275.299 272.619 273.543C272.47 273.513 272.351 273.335 272.41 273.186C272.44 273.037 272.619 272.918 272.768 272.977C280.331 274.793 285.632 281.461 285.632 289.261L283.309 377.882C283.279 378.001 283.16 378.15 282.981 378.15Z" fill="#FCA32D"/>
                        <path d="M281.7 427.416C281.521 427.416 281.402 427.268 281.402 427.119L282.296 393.451C282.296 393.272 282.445 393.153 282.593 393.153C282.772 393.153 282.891 393.302 282.891 393.451L281.998 427.119C281.998 427.268 281.849 427.416 281.7 427.416Z" fill="#FCA32D"/>
                        <path d="M359.69 296.286C359.541 296.286 359.422 296.197 359.392 296.048L358.886 293.428C358.171 289.737 356.534 286.254 354.181 283.367C350.072 278.276 343.937 275.18 337.416 274.853L323.808 274.168C323.629 274.168 323.51 274.019 323.51 273.841C323.51 273.662 323.629 273.543 323.837 273.543L337.446 274.228C344.146 274.555 350.429 277.74 354.658 282.98C357.07 285.956 358.737 289.529 359.482 293.309L359.988 295.959C360.018 296.108 359.928 296.286 359.75 296.316C359.72 296.286 359.72 296.286 359.69 296.286Z" fill="#EF8E18"/>
                        <path d="M373.268 365.587C373.119 365.587 373 365.498 372.97 365.349L361.387 306.348C361.357 306.199 361.446 306.02 361.625 305.991C361.774 305.961 361.952 306.05 361.982 306.229L373.566 365.23C373.596 365.379 373.506 365.557 373.328 365.587C373.328 365.587 373.298 365.587 373.268 365.587Z" fill="#EF8E18"/>
                        <path d="M382.113 410.568C381.964 410.568 381.845 410.478 381.815 410.329L374.252 371.809C374.222 371.66 374.311 371.481 374.49 371.452C374.669 371.422 374.818 371.511 374.847 371.69L382.411 410.21C382.441 410.359 382.351 410.538 382.173 410.568C382.143 410.568 382.143 410.568 382.113 410.568Z" fill="#EF8E18"/>
                        <path d="M238.492 203.765C237.48 225.258 234.026 246.662 228.249 267.381C226.819 272.561 225.182 277.8 222.442 282.414C219.702 287.058 215.682 291.106 210.62 292.982C202.997 295.81 193.974 293.041 188.168 287.296C182.361 281.58 179.502 273.364 178.907 265.237C178.311 257.111 179.77 248.984 181.587 241.036C182.808 235.796 184.148 230.557 185.756 225.407C187.572 219.573 189.627 213.857 192.098 208.26C193.26 205.641 194.481 203.081 195.791 200.55C198.828 194.686 202.342 189.09 206.362 183.85C211.752 176.855 221.221 163.131 230.601 171.913C238.969 179.802 238.999 193.198 238.492 203.765Z" fill="#FFCBBB"/>
                        <path d="M233.401 227.967L185.756 225.467C187.572 219.632 189.627 213.917 192.099 208.32L233.401 227.967Z" fill="#F6AF9B"/>
                        <path d="M261.927 130.952L253.887 129.374L250.701 103.505C250.194 99.3673 253.053 95.5569 257.162 94.902L282.682 90.7939L282.295 100.588L261.927 130.952Z" fill="#2E3D63"/>
                        <path d="M296.589 110.471C296.589 118.092 293.343 124.284 289.353 124.284C285.363 124.284 282.117 118.092 282.117 110.471C282.117 102.85 285.363 99.665 289.353 99.665C293.343 99.665 296.589 102.85 296.589 110.471Z" fill="#2E3D63"/>
                        <path d="M281.849 110.769V139.138V156.672L272.29 162.685L257.938 156.672V139.138V110.769H269.878H281.849Z" fill="#FFCBBB"/>
                        <path d="M281.849 140.537V154.915C277.68 150.718 271.069 144.228 267.287 140.537H281.849Z" fill="#F6AF9B"/>
                        <path d="M290.87 99.8435L294.682 132.916C295.724 142.115 286.85 149.289 278.095 146.282C271.425 143.99 265.35 140.716 264.606 136.429C263.117 127.915 264.159 109.578 264.517 104.368C264.576 103.535 265.172 102.85 266.006 102.671L288.696 98.236C289.739 98.0276 290.751 98.7718 290.87 99.8435Z" fill="#FFCBBB"/>
                        <path d="M296.529 104.934C290.425 107.941 272.469 104.904 269.342 98.5933C266.245 92.2823 277.144 84.1258 285.273 82.0717C291.884 80.4047 298.852 81.7443 301.979 88.0254C305.105 94.3066 302.664 101.927 296.529 104.934Z" fill="#2E3D63"/>
                        <path d="M278.185 95.1105C278.185 99.0994 275.147 103.624 269.787 103.624C264.427 103.624 258.77 99.0994 258.77 95.1105C258.77 91.1215 263.117 87.8767 268.477 87.8767C273.837 87.8767 278.185 91.1215 278.185 95.1105Z" fill="#2E3D63"/>
                        <path d="M294.117 106.482H270.831C266.781 106.482 263.803 110.262 264.727 114.192L265.65 118.032C265.65 118.032 267.407 124.879 256.627 125.474L257.788 101.987H293.105L294.117 106.482Z" fill="#2E3D63"/>
                        <path d="M253.857 113.894C253.767 113.894 253.678 113.865 253.618 113.775C253.529 113.656 253.559 113.448 253.678 113.359L261.331 107.643C261.45 107.554 261.658 107.583 261.748 107.703C261.837 107.822 261.807 108.03 261.688 108.119L254.035 113.835C253.976 113.894 253.916 113.894 253.857 113.894Z" fill="#727B91"/>
                        <path d="M254.78 117.973C254.691 117.973 254.602 117.943 254.542 117.854C254.453 117.735 254.483 117.526 254.602 117.437L262.255 111.721C262.374 111.632 262.582 111.662 262.672 111.781C262.761 111.9 262.731 112.108 262.612 112.198L254.959 117.913C254.9 117.943 254.84 117.973 254.78 117.973Z" fill="#727B91"/>
                        <path d="M257.638 133.095C260.829 133.095 263.415 130.51 263.415 127.32C263.415 124.131 260.829 121.545 257.638 121.545C254.448 121.545 251.861 124.131 251.861 127.32C251.861 130.51 254.448 133.095 257.638 133.095Z" fill="#FFCBBB"/>
                        <path d="M260.944 127.707C260.795 127.707 260.676 127.588 260.646 127.469C260.408 126.07 259.246 124.849 257.876 124.552C256.507 124.254 254.928 124.879 254.154 126.04C254.065 126.189 253.886 126.219 253.737 126.129C253.588 126.04 253.559 125.861 253.648 125.713C254.571 124.313 256.387 123.599 257.996 123.956C259.633 124.313 260.944 125.713 261.212 127.38C261.241 127.558 261.122 127.707 260.973 127.737C261.003 127.707 260.973 127.707 260.944 127.707Z" fill="#350453"/>
                        <path d="M255.137 129.076C255.018 129.076 254.899 128.987 254.839 128.868C254.243 127.112 255.077 125.028 256.685 124.105C256.834 124.016 257.013 124.075 257.102 124.224C257.191 124.373 257.132 124.551 256.983 124.641C255.643 125.415 254.928 127.231 255.405 128.689C255.464 128.838 255.375 129.017 255.226 129.076C255.196 129.047 255.167 129.076 255.137 129.076Z" fill="#350453"/>
                        <path d="M278.216 120.205C278.792 120.205 279.258 119.739 279.258 119.163C279.258 118.588 278.792 118.122 278.216 118.122C277.64 118.122 277.174 118.588 277.174 119.163C277.174 119.739 277.64 120.205 278.216 120.205Z" fill="#350453"/>
                        <path d="M288.728 120.205C289.303 120.205 289.77 119.739 289.77 119.163C289.77 118.588 289.303 118.122 288.728 118.122C288.152 118.122 287.686 118.588 287.686 119.163C287.686 119.739 288.152 120.205 288.728 120.205Z" fill="#350453"/>
                        <path d="M275.822 113.591C278.29 112.893 280.121 111.724 279.91 110.981C279.7 110.237 277.528 110.2 275.06 110.899C272.591 111.597 270.76 112.766 270.971 113.51C271.181 114.253 273.353 114.29 275.822 113.591Z" fill="#2E3D63"/>
                        <path d="M292.752 112.781C292.963 112.037 291.132 110.868 288.664 110.17C286.195 109.472 284.023 109.508 283.813 110.252C283.602 110.995 285.433 112.164 287.901 112.862C290.37 113.561 292.542 113.524 292.752 112.781Z" fill="#2E3D63"/>
                        <path d="M283.934 128.481C283.785 128.481 283.666 128.392 283.636 128.243C283.606 128.094 283.696 127.915 283.874 127.885L286.405 127.32C286.703 127.111 286.822 126.724 286.733 126.367L283.189 113.686C283.16 113.537 283.249 113.358 283.398 113.329C283.576 113.269 283.725 113.388 283.755 113.537L287.269 126.218C287.448 126.844 287.18 127.498 286.644 127.856L286.554 127.885L283.964 128.481C283.964 128.481 283.964 128.481 283.934 128.481Z" fill="#350453"/>
                        <path d="M285.272 133.184C284.766 133.036 284.23 132.976 283.724 132.976C281.967 133.006 280.27 133.929 279.257 135.358C279.168 135.506 279.198 135.685 279.347 135.774C279.496 135.864 279.674 135.834 279.764 135.685C280.657 134.405 282.176 133.571 283.724 133.571C285.272 133.542 286.821 134.316 287.744 135.596C287.833 135.745 288.042 135.774 288.161 135.655C288.31 135.566 288.34 135.358 288.22 135.238C287.506 134.226 286.434 133.512 285.272 133.184Z" fill="#350453"/>
                        <path d="M272.558 94.0983C272.439 94.0983 272.29 94.0685 272.171 94.0387C271.069 93.7411 270.652 92.4015 270.89 91.2405C271.099 90.2581 271.635 89.3949 272.23 88.6804C272.111 88.5911 271.992 88.5316 271.873 88.472C270.771 87.8767 269.372 87.6683 267.674 87.8171C264.786 88.1148 262.046 89.3949 259.932 91.3893C259.813 91.5084 259.634 91.5084 259.515 91.3893C259.396 91.2703 259.396 91.0917 259.515 90.9726C261.719 88.859 264.607 87.5492 267.615 87.2218C269.431 87.0431 270.95 87.2813 272.171 87.9362C272.349 88.0255 272.498 88.1148 272.647 88.2339C272.796 88.0553 272.945 87.9064 273.094 87.7576C277.352 83.4709 283.248 80.9406 289.353 80.7917C289.531 80.7917 289.65 80.9108 289.65 81.0894C289.65 81.268 289.531 81.3871 289.353 81.3871C283.427 81.536 277.65 84.0068 273.511 88.1743C273.392 88.2934 273.243 88.4423 273.124 88.5911C274.077 89.4544 274.642 90.6451 274.553 91.8359C274.523 92.4908 274.285 93.0564 273.898 93.4731C273.541 93.8601 273.064 94.0983 272.558 94.0983ZM272.707 89.0674C272.171 89.7223 271.665 90.4963 271.486 91.3596C271.307 92.2229 271.575 93.2648 272.32 93.4434C272.707 93.5327 273.153 93.3838 273.451 93.0564C273.719 92.7587 273.898 92.3122 273.928 91.8061C274.017 90.8237 273.541 89.8116 272.707 89.0674Z" fill="#FEF4DE"/>
                        <path d="M240.309 162.03C237.897 160.839 235.247 160.125 232.716 159.976C225.212 159.5 217.857 163.012 212.259 168.073C206.69 173.134 202.64 179.623 198.918 186.172C193.737 195.341 189.091 204.807 185.012 214.512L240.309 229.932V162.03Z" fill="#B9B5B2"/>
                        <path d="M239.802 190.608C239.653 190.608 239.534 190.519 239.504 190.37C237.658 180.159 230.273 171.109 220.625 167.269C220.476 167.21 220.387 167.031 220.446 166.882C220.506 166.733 220.685 166.644 220.833 166.704C230.66 170.603 238.224 179.861 240.07 190.251C240.1 190.429 239.981 190.578 239.832 190.608C239.832 190.608 239.832 190.608 239.802 190.608Z" fill="white"/>
                        <path d="M265.203 176.468C265.114 176.468 265.055 176.438 264.995 176.379L252.22 163.489C252.101 163.37 252.101 163.191 252.22 163.072C252.339 162.953 252.518 162.953 252.637 163.072L265.114 175.664L270.325 165.602C270.415 165.453 270.593 165.394 270.742 165.483C270.891 165.573 270.951 165.751 270.861 165.9L265.471 176.319C265.442 176.408 265.352 176.468 265.263 176.468C265.233 176.468 265.233 176.468 265.203 176.468Z" fill="white"/>
                        <path d="M279.497 174.979C279.407 174.979 279.318 174.92 279.258 174.86L272.767 165.93C272.677 165.781 272.707 165.602 272.826 165.513C272.945 165.424 273.154 165.453 273.243 165.572L279.497 174.146L288.043 163.102C288.132 162.983 288.341 162.953 288.46 163.042C288.579 163.131 288.609 163.34 288.519 163.459L279.705 174.83C279.675 174.92 279.586 174.979 279.497 174.979Z" fill="white"/>
                        <path d="M234.471 216.626C234.442 216.626 234.412 216.626 234.382 216.626L190.549 202.337C190.4 202.277 190.311 202.128 190.37 201.95C190.43 201.801 190.579 201.712 190.757 201.771L234.59 216.06C234.739 216.12 234.829 216.268 234.769 216.447C234.71 216.566 234.59 216.626 234.471 216.626Z" fill="white"/>
                        <path d="M273.005 260.028C272.826 260.028 272.707 259.879 272.707 259.731V176.17C272.707 175.992 272.856 175.873 273.005 175.873C273.184 175.873 273.303 176.021 273.303 176.17V259.731C273.303 259.879 273.184 260.028 273.005 260.028Z" fill="white"/>
                        <path d="M267.348 229.575L267.437 236.303L270.087 237.255L274.465 232.165L267.348 229.575Z" fill="#FADDBF"/>
                        <path d="M274.465 232.165L285.75 201.206L290.038 189.358L286.495 188.078L282.922 186.768L278.634 198.616L267.348 229.575L274.465 232.165Z" fill="#FFB548"/>
                        <path d="M272.143 231.331L283.428 200.342L287.746 188.524L287.895 188.584L288.044 188.643L283.756 200.461L272.47 231.45L272.143 231.331Z" fill="#FBF2D5"/>
                        <path d="M269.344 230.319L280.6 199.33L284.918 187.482L285.066 187.542L285.245 187.601L280.927 199.449L269.642 230.408L269.344 230.319Z" fill="#FBF2D5"/>
                        <path d="M267.467 240.292L270.088 237.255L267.438 236.303L267.467 240.292Z" fill="#0F3843"/>
                        <path d="M287.717 181.558L289.742 182.302C291.082 182.779 291.767 184.267 291.29 185.607L290.248 188.435L283.369 185.934L284.411 183.106C284.888 181.767 286.377 181.082 287.717 181.558Z" fill="#F76652"/>
                        <path d="M282.52 186.888L290.299 189.719L291.276 187.033L283.497 184.203L282.52 186.888Z" fill="#2E3D63"/>
                        <path d="M295.994 221.091C295.667 223.234 293.284 224.187 290.991 224.484C292.123 225.229 292.897 226.181 292.897 227.461C292.867 231.867 288.282 232.522 286.019 232.105C286.763 232.552 287.329 233.177 287.597 234.01C288.043 235.469 287.239 237.077 286.048 237.999C284.827 238.922 283.309 239.309 281.79 239.547C281.224 239.637 280.688 239.726 280.122 239.786C280.301 241.095 279.676 242.465 278.723 243.388C277.532 244.489 275.954 245.025 274.375 245.412C270.623 246.305 265.859 246.573 261.72 245.62C261.243 246.573 260.737 247.525 260.231 248.478C258.533 251.604 256.657 254.64 254.633 257.557C245.878 270.239 234.264 280.985 220.805 288.517C215.504 291.493 209.489 294.054 203.504 292.952C196.834 291.732 191.593 285.927 189.806 279.378C188.377 274.019 188.525 266.22 191.533 261.338C194.124 257.141 198.174 253.062 201.39 249.311C209.191 240.202 218.095 232.016 227.832 224.991C233.371 221.002 239.208 217.37 245.252 214.155C248.647 212.339 255.407 210.077 261.601 209.243C272.231 207.844 283.338 210.404 292.48 216C294.327 217.221 296.322 218.948 295.994 221.091Z" fill="#FFCBBB"/>
                        <path d="M260.231 248.508C258.533 251.633 256.657 254.67 254.632 257.587C245.193 247.406 238.076 234.903 234.234 221.656L244.061 218.799C247.188 229.634 252.816 239.904 260.231 248.508Z" fill="#2E3D63"/>
                        <path d="M192.158 260.742C192.099 260.742 192.039 260.713 191.979 260.683C191.831 260.594 191.801 260.415 191.89 260.266C193.766 257.468 196.208 254.729 198.56 252.11C199.483 251.097 200.347 250.115 201.151 249.162C208.983 240.024 217.886 231.837 227.653 224.782C232.18 221.508 236.914 218.471 241.738 215.762C241.887 215.673 242.066 215.732 242.155 215.881C242.245 216.03 242.185 216.209 242.036 216.298C237.212 219.007 232.507 222.043 227.981 225.288C218.244 232.313 209.37 240.47 201.568 249.579C200.734 250.562 199.871 251.514 198.947 252.556C196.595 255.176 194.183 257.885 192.337 260.653C192.337 260.713 192.247 260.742 192.158 260.742Z" fill="#350453"/>
                        <path d="M286.108 224.425C281.016 224.425 275.953 223.472 271.219 221.627C271.07 221.567 270.981 221.389 271.04 221.24C271.1 221.091 271.278 221.002 271.427 221.061C277.293 223.353 283.696 224.246 289.949 223.621C290.098 223.621 290.247 223.74 290.277 223.889C290.306 224.068 290.158 224.187 290.009 224.217C288.728 224.365 287.418 224.425 286.108 224.425Z" fill="#350453"/>
                        <path d="M274.642 240.381C271.188 240.381 267.734 239.905 264.458 238.982C264.309 238.922 264.22 238.773 264.25 238.624C264.309 238.476 264.458 238.386 264.607 238.416C269.372 239.756 274.553 240.113 279.496 239.458C279.645 239.428 279.824 239.547 279.824 239.726C279.854 239.905 279.734 240.053 279.556 240.053C277.948 240.262 276.31 240.381 274.642 240.381Z" fill="#350453"/>
                        <path d="M279.945 233.028C276.133 233.028 272.351 232.343 268.748 231.033C268.599 230.974 268.51 230.795 268.569 230.646C268.629 230.498 268.808 230.408 268.957 230.468C274.287 232.433 280.064 232.939 285.632 231.926C285.781 231.897 285.96 232.016 285.99 232.165C286.019 232.313 285.9 232.492 285.751 232.522C283.816 232.849 281.88 233.028 279.945 233.028Z" fill="#350453"/>
                        <path d="M241.381 236.124C247.449 236.124 252.369 231.206 252.369 225.139C252.369 219.073 247.449 214.155 241.381 214.155C235.312 214.155 230.393 219.073 230.393 225.139C230.393 231.206 235.312 236.124 241.381 236.124Z" fill="#2E3D63"/>
                        <path d="M241.381 232.403C245.394 232.403 248.647 229.151 248.647 225.139C248.647 221.128 245.394 217.876 241.381 217.876C237.368 217.876 234.115 221.128 234.115 225.139C234.115 229.151 237.368 232.403 241.381 232.403Z" fill="white"/>
                        <path d="M241.38 225.913C241.807 225.913 242.154 225.567 242.154 225.139C242.154 224.712 241.807 224.365 241.38 224.365C240.952 224.365 240.605 224.712 240.605 225.139C240.605 225.567 240.952 225.913 241.38 225.913Z" fill="#2E2E2E"/>
                        <path d="M241.298 219.807L241.084 225.012L241.679 225.037L241.893 219.831L241.298 219.807Z" fill="#350453"/>
                        <path d="M244.447 227.938L241.201 225.556L241.559 225.08L244.804 227.432L244.447 227.938Z" fill="#350453"/>
                        <path d="M310.912 230.349L355.162 201.682C355.162 201.682 331.101 158.875 303.14 159.916C275.149 160.988 310.912 230.349 310.912 230.349Z" fill="#B9B5B2"/>
                        <path d="M421.477 195.043C423.651 194.359 425.884 193.615 427.433 191.977C428.981 190.34 429.488 187.452 427.88 185.845C426.51 184.505 424.187 184.595 422.579 185.637C420.971 186.678 419.988 188.435 419.244 190.191C418.797 191.233 418.44 192.454 418.857 193.495C419.274 194.567 420.822 195.192 421.596 194.359L421.477 195.043Z" fill="#FFCBBB"/>
                        <path d="M420.882 203.14C423.055 202.456 425.289 201.712 426.837 200.074C428.386 198.437 428.892 195.549 427.284 193.942C425.914 192.602 423.591 192.692 421.983 193.734C420.375 194.775 419.393 196.532 418.648 198.288C418.202 199.33 417.844 200.551 418.261 201.592C418.678 202.664 420.226 203.289 421.001 202.456L420.882 203.14Z" fill="#FFCBBB"/>
                        <path d="M419.096 210.969C421.27 210.285 423.504 209.541 425.052 207.903C426.601 206.236 427.107 203.379 425.499 201.771C424.129 200.431 421.806 200.521 420.198 201.563C418.59 202.605 417.608 204.361 416.863 206.117C416.416 207.159 416.059 208.38 416.476 209.422C416.893 210.493 418.441 211.118 419.216 210.285L419.096 210.969Z" fill="#FFCBBB"/>
                        <path d="M340.422 217.638L389.139 202.009C389.139 202.009 409.358 192.84 415.075 195.549C423.115 199.39 416.117 216.834 403.104 229.277C387.828 243.894 358.765 251.484 358.765 251.484C347.807 256.664 334.764 250.919 331.28 239.339C328.927 231.42 329.821 222.936 340.422 217.638Z" fill="#FFCBBB"/>
                        <path d="M394.291 187.839C395.214 187.065 396.167 186.321 397.328 186.024C398.49 185.726 399.859 185.964 400.574 186.917C401.348 187.958 401.11 189.417 400.783 190.667C398.698 198.497 394.41 205.73 388.544 211.297C387.204 212.547 385.774 213.768 384.077 214.423C381.814 215.316 378.896 215.137 377.317 213.053C375.948 211.297 376.901 209.511 377.854 207.784C380.504 202.962 383.75 198.467 387.442 194.418C389.556 192.067 391.849 189.864 394.291 187.839Z" fill="#FFCBBB"/>
                        <path d="M395.482 212.964C394.827 217.578 392.237 221.924 388.365 224.514C384.494 227.104 379.343 227.818 374.995 226.151C373.983 225.764 381.933 211.297 382.767 210.047C384.435 207.546 386.251 205.194 388.246 202.962C390.39 200.55 392.177 198.645 393.934 202.456C395.423 205.7 395.989 209.451 395.482 212.964Z" fill="#FFCBBB"/>
                        <path d="M321.365 252.229H321.335C321.156 252.199 321.067 252.05 321.067 251.901C323.777 232.552 321.484 212.458 315.886 193.733C315.826 193.585 315.915 193.406 316.094 193.346C316.243 193.287 316.422 193.376 316.481 193.555C322.109 212.339 324.402 232.552 321.662 251.961C321.633 252.11 321.514 252.229 321.365 252.229Z" fill="white"/>
                        <path d="M318.357 202.307C318.297 202.307 318.208 202.277 318.149 202.247C318.029 202.128 318 201.95 318.119 201.831C320.173 199.419 321.245 196.204 321.126 193.049C321.126 192.87 321.245 192.751 321.424 192.721C321.573 192.721 321.722 192.841 321.752 193.019C321.901 196.323 320.739 199.687 318.595 202.218C318.536 202.247 318.446 202.307 318.357 202.307Z" fill="white"/>
                        <path d="M394.738 191.114C393.905 191.114 393.071 190.816 392.445 190.28C392.326 190.161 392.297 189.983 392.416 189.864C392.535 189.744 392.713 189.715 392.833 189.834C393.666 190.548 394.947 190.727 395.959 190.251C396.972 189.774 397.627 188.673 397.597 187.571C397.597 187.393 397.716 187.274 397.895 187.274C398.073 187.274 398.193 187.393 398.193 187.571C398.222 188.911 397.418 190.251 396.197 190.816C395.751 190.995 395.245 191.114 394.738 191.114Z" fill="#350453"/>
                        <path d="M392.564 221.24C392.504 221.24 392.445 221.21 392.385 221.18C392.236 221.091 392.206 220.882 392.325 220.763C395.869 215.881 396.524 209.422 394.023 204.331C393.963 204.212 393.993 204.093 394.053 204.004C395.154 202.724 396.167 201.295 397.001 199.806C397.09 199.657 397.269 199.598 397.417 199.687C397.566 199.777 397.626 199.955 397.537 200.104C396.703 201.563 395.75 202.962 394.648 204.242C397.149 209.511 396.435 216.09 392.802 221.091C392.742 221.18 392.653 221.24 392.564 221.24Z" fill="#350453"/>
                        <path d="M341.525 219.424C341.406 219.424 341.316 219.364 341.257 219.245C341.167 219.096 341.227 218.918 341.376 218.828C353.466 212.696 366.062 208.141 378.837 205.284C379.015 205.254 379.164 205.343 379.194 205.522C379.224 205.671 379.134 205.849 378.956 205.879C366.241 208.707 353.674 213.262 341.614 219.364C341.614 219.424 341.584 219.424 341.525 219.424Z" fill="#350453"/>
                        <path d="M176.285 190.429H100.828V255.771H176.285V190.429Z" fill="white"/>
                        <path d="M121.852 234.516L107.439 225.288H136.324L121.852 234.516Z" fill="#E1E7F7"/>
                        <path d="M125.514 228.473L136.324 225.288L107.35 224.633L125.514 228.473Z" fill="white"/>
                        <path d="M175.302 225.675H101.84C101.542 225.675 101.334 225.437 101.334 225.169C101.334 224.901 101.572 224.663 101.84 224.663H175.302C175.6 224.663 175.809 224.901 175.809 225.169C175.809 225.437 175.6 225.675 175.302 225.675Z" fill="#E1E7F7"/>
                        <path d="M175.302 248.24H101.84C101.542 248.24 101.334 248.002 101.334 247.734C101.334 247.466 101.572 247.228 101.84 247.228H175.302C175.6 247.228 175.809 247.466 175.809 247.734C175.809 248.002 175.6 248.24 175.302 248.24Z" fill="#E1E7F7"/>
                        <path d="M175.302 231.034H101.84C101.542 231.034 101.334 230.795 101.334 230.528C101.334 230.26 101.572 230.021 101.84 230.021H175.302C175.6 230.021 175.809 230.26 175.809 230.528C175.809 230.795 175.6 231.034 175.302 231.034Z" fill="#E1E7F7"/>
                        <path d="M175.302 196.591H101.84C101.542 196.591 101.334 196.353 101.334 196.085C101.334 195.817 101.572 195.579 101.84 195.579H175.302C175.6 195.579 175.809 195.817 175.809 196.085C175.809 196.353 175.6 196.591 175.302 196.591Z" fill="#E1E7F7"/>
                        <path d="M175.302 202.366H101.84C101.542 202.366 101.334 202.128 101.334 201.86C101.334 201.563 101.572 201.354 101.84 201.354H175.302C175.6 201.354 175.809 201.592 175.809 201.86C175.839 202.158 175.6 202.366 175.302 202.366Z" fill="#E1E7F7"/>
                        <path d="M175.302 208.528H101.84C101.542 208.528 101.334 208.29 101.334 208.022C101.334 207.755 101.572 207.516 101.84 207.516H175.302C175.6 207.516 175.809 207.755 175.809 208.022C175.809 208.29 175.6 208.528 175.302 208.528Z" fill="#E1E7F7"/>
                        <path d="M154.875 191.144H101.84C101.542 191.144 101.334 190.906 101.334 190.638C101.334 190.34 101.572 190.132 101.84 190.132H154.875C162.23 190.132 168.99 187.482 172.92 183.017C173.099 182.809 173.426 182.779 173.665 182.957C173.873 183.136 173.903 183.463 173.724 183.702C169.555 188.345 162.528 191.144 154.875 191.144Z" fill="white"/>
                        <path d="M175.302 213.976H101.84C101.542 213.976 101.334 213.738 101.334 213.47C101.334 213.202 101.572 212.964 101.84 212.964H175.302C175.6 212.964 175.809 213.202 175.809 213.47C175.809 213.738 175.6 213.976 175.302 213.976Z" fill="#E1E7F7"/>
                        <path d="M175.302 220.257H101.84C101.542 220.257 101.334 220.019 101.334 219.751C101.334 219.483 101.572 219.245 101.84 219.245H175.302C175.6 219.245 175.809 219.483 175.809 219.751C175.809 220.019 175.6 220.257 175.302 220.257Z" fill="#E1E7F7"/>
                        <path d="M175.302 237.047H101.84C101.542 237.047 101.334 236.809 101.334 236.541C101.334 236.243 101.572 236.035 101.84 236.035H175.302C175.6 236.035 175.809 236.273 175.809 236.541C175.839 236.809 175.6 237.047 175.302 237.047Z" fill="#E1E7F7"/>
                        <path d="M175.302 242.524H101.84C101.542 242.524 101.334 242.286 101.334 242.018C101.334 241.75 101.572 241.512 101.84 241.512H175.302C175.6 241.512 175.809 241.75 175.809 242.018C175.809 242.286 175.6 242.524 175.302 242.524Z" fill="#E1E7F7"/>
                        <path d="M157.467 223.383L131.59 212.726H166.311L157.467 223.383Z" fill="#E1E7F7"/>
                        <path d="M159.313 218.501L130.756 212.428H165.477L159.313 218.501Z" fill="white"/>
                        <path d="M104.879 194.954L115.569 207.903L143.263 194.984L104.879 194.954Z" fill="#E1E7F7"/>
                        <path d="M104.432 194.954L109.881 203.349L142.339 194.954H104.432Z" fill="white"/>
                        <path d="M155.769 251.574V255.027H122.239V251.574C122.239 249.044 120.184 246.99 117.653 246.99H95.498V264.583H182.509V246.99H160.354C157.823 246.96 155.769 249.044 155.769 251.574Z" fill="#F76652"/>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M328.004 262.737C328.004 258.629 323.358 255.295 317.641 255.295H300.667C294.95 255.295 290.305 258.629 290.305 262.737C290.305 263.213 290.841 263.6 291.496 263.6H326.812C327.468 263.6 328.004 263.213 328.004 262.737Z" fill="white"/>
                        <path d="M169.257 475.612C168.811 475.612 168.394 475.314 168.275 474.838L117.563 268.244L66.8511 474.838C66.732 475.374 66.1662 475.701 65.6302 475.582C65.0942 475.463 64.7666 474.897 64.8857 474.362L116.58 263.809C116.699 263.362 117.086 263.035 117.563 263.035C118.039 263.035 118.427 263.362 118.546 263.809L170.24 474.362C170.359 474.897 170.032 475.433 169.496 475.582C169.406 475.612 169.347 475.612 169.257 475.612Z" fill="#E1E7F7"/>
                        <path d="M595.113 475.612C594.666 475.612 594.249 475.314 594.13 474.838L543.418 268.244L492.707 474.838C492.587 475.374 492.022 475.701 491.486 475.582C490.95 475.463 490.622 474.897 490.741 474.362L542.436 263.809C542.555 263.362 542.942 263.035 543.418 263.035C543.895 263.035 544.282 263.362 544.401 263.809L596.096 474.362C596.215 474.897 595.887 475.433 595.351 475.582C595.292 475.612 595.202 475.612 595.113 475.612Z" fill="#E1E7F7"/>
                        <path d="M629 263.213H48.8652V271.251H629V263.213Z" fill="#E1E7F7"/>
                        <path d="M400.87 233.385H560.272C561.165 233.385 561.91 232.641 562.059 231.659L574.982 130.595C575.131 129.374 574.297 128.302 573.196 128.302H413.764C412.871 128.302 412.127 129.047 411.978 130.029L399.054 231.093C398.935 232.284 399.798 233.385 400.87 233.385Z" fill="#727B91"/>
                        <path d="M473.32 181.737L476.655 233.385H498.304L473.32 181.737Z" fill="#475577"/>
                        <path d="M473.291 181.737H503.962L528.887 265.148H498.245L473.291 181.737Z" fill="#727B91"/>
                        <path d="M463.434 265.416H553.512C553.512 262.082 550.802 259.373 547.467 259.373H469.478C466.143 259.344 463.434 262.052 463.434 265.416Z" fill="#727B91"/>
                        <path d="M537.402 156.999C538.406 156.999 539.219 156.186 539.219 155.184C539.219 154.181 538.406 153.368 537.402 153.368C536.399 153.368 535.586 154.181 535.586 155.184C535.586 156.186 536.399 156.999 537.402 156.999Z" fill="#475577"/>
                        <path d="M531.924 156.999C532.927 156.999 533.74 156.186 533.74 155.184C533.74 154.181 532.927 153.368 531.924 153.368C530.921 153.368 530.107 154.181 530.107 155.184C530.107 156.186 530.921 156.999 531.924 156.999Z" fill="#475577"/>
                        <path d="M526.445 156.999C527.449 156.999 528.262 156.186 528.262 155.184C528.262 154.181 527.449 153.368 526.445 153.368C525.442 153.368 524.629 154.181 524.629 155.184C524.629 156.186 525.442 156.999 526.445 156.999Z" fill="#475577"/>
                        <path d="M520.965 156.999C521.968 156.999 522.781 156.186 522.781 155.184C522.781 154.181 521.968 153.368 520.965 153.368C519.962 153.368 519.148 154.181 519.148 155.184C519.148 156.186 519.962 156.999 520.965 156.999Z" fill="#475577"/>
                        <path d="M515.486 156.999C516.49 156.999 517.303 156.186 517.303 155.184C517.303 154.181 516.49 153.368 515.486 153.368C514.483 153.368 513.67 154.181 513.67 155.184C513.67 156.186 514.483 156.999 515.486 156.999Z" fill="#475577"/>
                        <path d="M509.977 156.999C510.98 156.999 511.793 156.186 511.793 155.184C511.793 154.181 510.98 153.368 509.977 153.368C508.973 153.368 508.16 154.181 508.16 155.184C508.16 156.186 508.973 156.999 509.977 156.999Z" fill="#475577"/>
                        <path d="M504.498 156.999C505.501 156.999 506.315 156.186 506.315 155.184C506.315 154.181 505.501 153.368 504.498 153.368C503.495 153.368 502.682 154.181 502.682 155.184C502.682 156.186 503.495 156.999 504.498 156.999Z" fill="#475577"/>
                        <path d="M499.02 156.999C500.023 156.999 500.836 156.186 500.836 155.184C500.836 154.181 500.023 153.368 499.02 153.368C498.016 153.368 497.203 154.181 497.203 155.184C497.203 156.186 498.016 156.999 499.02 156.999Z" fill="#475577"/>
                        <path d="M493.539 156.999C494.542 156.999 495.356 156.186 495.356 155.184C495.356 154.181 494.542 153.368 493.539 153.368C492.536 153.368 491.723 154.181 491.723 155.184C491.723 156.186 492.536 156.999 493.539 156.999Z" fill="#475577"/>
                        <path d="M488.061 156.999C489.064 156.999 489.877 156.186 489.877 155.184C489.877 154.181 489.064 153.368 488.061 153.368C487.057 153.368 486.244 154.181 486.244 155.184C486.244 156.186 487.057 156.999 488.061 156.999Z" fill="#475577"/>
                        <path d="M482.582 156.999C483.585 156.999 484.399 156.186 484.399 155.184C484.399 154.181 483.585 153.368 482.582 153.368C481.579 153.368 480.766 154.181 480.766 155.184C480.766 156.186 481.579 156.999 482.582 156.999Z" fill="#475577"/>
                        <path d="M477.104 156.999C478.107 156.999 478.92 156.186 478.92 155.184C478.92 154.181 478.107 153.368 477.104 153.368C476.1 153.368 475.287 154.181 475.287 155.184C475.287 156.186 476.1 156.999 477.104 156.999Z" fill="#475577"/>
                        <path d="M471.594 156.999C472.597 156.999 473.41 156.186 473.41 155.184C473.41 154.181 472.597 153.368 471.594 153.368C470.591 153.368 469.777 154.181 469.777 155.184C469.777 156.186 470.591 156.999 471.594 156.999Z" fill="#475577"/>
                        <path d="M466.115 156.999C467.119 156.999 467.932 156.186 467.932 155.184C467.932 154.181 467.119 153.368 466.115 153.368C465.112 153.368 464.299 154.181 464.299 155.184C464.299 156.186 465.112 156.999 466.115 156.999Z" fill="#475577"/>
                        <path d="M460.635 156.999C461.638 156.999 462.451 156.186 462.451 155.184C462.451 154.181 461.638 153.368 460.635 153.368C459.632 153.368 458.818 154.181 458.818 155.184C458.818 156.186 459.632 156.999 460.635 156.999Z" fill="#475577"/>
                        <path d="M455.156 156.999C456.159 156.999 456.973 156.186 456.973 155.184C456.973 154.181 456.159 153.368 455.156 153.368C454.153 153.368 453.34 154.181 453.34 155.184C453.34 156.186 454.153 156.999 455.156 156.999Z" fill="#475577"/>
                        <path d="M537.402 167.031C538.406 167.031 539.219 166.218 539.219 165.216C539.219 164.213 538.406 163.4 537.402 163.4C536.399 163.4 535.586 164.213 535.586 165.216C535.586 166.218 536.399 167.031 537.402 167.031Z" fill="#475577"/>
                        <path d="M531.924 167.031C532.927 167.031 533.74 166.218 533.74 165.216C533.74 164.213 532.927 163.4 531.924 163.4C530.921 163.4 530.107 164.213 530.107 165.216C530.107 166.218 530.921 167.031 531.924 167.031Z" fill="#475577"/>
                        <path d="M526.445 167.031C527.449 167.031 528.262 166.218 528.262 165.216C528.262 164.213 527.449 163.4 526.445 163.4C525.442 163.4 524.629 164.213 524.629 165.216C524.629 166.218 525.442 167.031 526.445 167.031Z" fill="#475577"/>
                        <path d="M520.965 167.031C521.968 167.031 522.781 166.218 522.781 165.216C522.781 164.213 521.968 163.4 520.965 163.4C519.962 163.4 519.148 164.213 519.148 165.216C519.148 166.218 519.962 167.031 520.965 167.031Z" fill="#475577"/>
                        <path d="M515.486 167.031C516.49 167.031 517.303 166.218 517.303 165.216C517.303 164.213 516.49 163.4 515.486 163.4C514.483 163.4 513.67 164.213 513.67 165.216C513.67 166.218 514.483 167.031 515.486 167.031Z" fill="#475577"/>
                        <path d="M509.977 167.031C510.98 167.031 511.793 166.218 511.793 165.216C511.793 164.213 510.98 163.4 509.977 163.4C508.973 163.4 508.16 164.213 508.16 165.216C508.16 166.218 508.973 167.031 509.977 167.031Z" fill="#475577"/>
                        <path d="M504.498 167.031C505.501 167.031 506.315 166.218 506.315 165.216C506.315 164.213 505.501 163.4 504.498 163.4C503.495 163.4 502.682 164.213 502.682 165.216C502.682 166.218 503.495 167.031 504.498 167.031Z" fill="#475577"/>
                        <path d="M499.02 167.031C500.023 167.031 500.836 166.218 500.836 165.216C500.836 164.213 500.023 163.4 499.02 163.4C498.016 163.4 497.203 164.213 497.203 165.216C497.203 166.218 498.016 167.031 499.02 167.031Z" fill="#475577"/>
                        <path d="M493.539 167.031C494.542 167.031 495.356 166.218 495.356 165.216C495.356 164.213 494.542 163.4 493.539 163.4C492.536 163.4 491.723 164.213 491.723 165.216C491.723 166.218 492.536 167.031 493.539 167.031Z" fill="#475577"/>
                        <path d="M488.061 167.031C489.064 167.031 489.877 166.218 489.877 165.216C489.877 164.213 489.064 163.4 488.061 163.4C487.057 163.4 486.244 164.213 486.244 165.216C486.244 166.218 487.057 167.031 488.061 167.031Z" fill="#475577"/>
                        <path d="M482.582 167.031C483.585 167.031 484.399 166.218 484.399 165.216C484.399 164.213 483.585 163.4 482.582 163.4C481.579 163.4 480.766 164.213 480.766 165.216C480.766 166.218 481.579 167.031 482.582 167.031Z" fill="#475577"/>
                        <path d="M477.104 167.031C478.107 167.031 478.92 166.218 478.92 165.216C478.92 164.213 478.107 163.4 477.104 163.4C476.1 163.4 475.287 164.213 475.287 165.216C475.287 166.218 476.1 167.031 477.104 167.031Z" fill="#475577"/>
                        <path d="M471.594 167.031C472.597 167.031 473.41 166.218 473.41 165.216C473.41 164.213 472.597 163.4 471.594 163.4C470.591 163.4 469.777 164.213 469.777 165.216C469.777 166.218 470.591 167.031 471.594 167.031Z" fill="#475577"/>
                        <path d="M466.115 167.031C467.119 167.031 467.932 166.218 467.932 165.216C467.932 164.213 467.119 163.4 466.115 163.4C465.112 163.4 464.299 164.213 464.299 165.216C464.299 166.218 465.112 167.031 466.115 167.031Z" fill="#475577"/>
                        <path d="M460.635 167.031C461.638 167.031 462.451 166.218 462.451 165.216C462.451 164.213 461.638 163.4 460.635 163.4C459.632 163.4 458.818 164.213 458.818 165.216C458.818 166.218 459.632 167.031 460.635 167.031Z" fill="#475577"/>
                        <path d="M455.156 167.031C456.159 167.031 456.973 166.218 456.973 165.216C456.973 164.213 456.159 163.4 455.156 163.4C454.153 163.4 453.34 164.213 453.34 165.216C453.34 166.218 454.153 167.031 455.156 167.031Z" fill="#475577"/>
                        <path d="M540.231 162.03C541.234 162.03 542.047 161.217 542.047 160.214C542.047 159.211 541.234 158.398 540.231 158.398C539.227 158.398 538.414 159.211 538.414 160.214C538.414 161.217 539.227 162.03 540.231 162.03Z" fill="#475577"/>
                        <path d="M534.752 162.03C535.755 162.03 536.568 161.217 536.568 160.214C536.568 159.211 535.755 158.398 534.752 158.398C533.749 158.398 532.936 159.211 532.936 160.214C532.936 161.217 533.749 162.03 534.752 162.03Z" fill="#475577"/>
                        <path d="M529.273 162.03C530.277 162.03 531.09 161.217 531.09 160.214C531.09 159.211 530.277 158.398 529.273 158.398C528.27 158.398 527.457 159.211 527.457 160.214C527.457 161.217 528.27 162.03 529.273 162.03Z" fill="#475577"/>
                        <path d="M523.764 162.03C524.767 162.03 525.58 161.217 525.58 160.214C525.58 159.211 524.767 158.398 523.764 158.398C522.761 158.398 521.947 159.211 521.947 160.214C521.947 161.217 522.761 162.03 523.764 162.03Z" fill="#475577"/>
                        <path d="M518.285 162.03C519.288 162.03 520.102 161.217 520.102 160.214C520.102 159.211 519.288 158.398 518.285 158.398C517.282 158.398 516.469 159.211 516.469 160.214C516.469 161.217 517.282 162.03 518.285 162.03Z" fill="#475577"/>
                        <path d="M512.805 162.03C513.808 162.03 514.621 161.217 514.621 160.214C514.621 159.211 513.808 158.398 512.805 158.398C511.802 158.398 510.988 159.211 510.988 160.214C510.988 161.217 511.802 162.03 512.805 162.03Z" fill="#475577"/>
                        <path d="M507.326 162.03C508.329 162.03 509.143 161.217 509.143 160.214C509.143 159.211 508.329 158.398 507.326 158.398C506.323 158.398 505.51 159.211 505.51 160.214C505.51 161.217 506.323 162.03 507.326 162.03Z" fill="#475577"/>
                        <path d="M501.848 162.03C502.851 162.03 503.664 161.217 503.664 160.214C503.664 159.211 502.851 158.398 501.848 158.398C500.845 158.398 500.031 159.211 500.031 160.214C500.031 161.217 500.845 162.03 501.848 162.03Z" fill="#475577"/>
                        <path d="M496.369 162.03C497.372 162.03 498.186 161.217 498.186 160.214C498.186 159.211 497.372 158.398 496.369 158.398C495.366 158.398 494.553 159.211 494.553 160.214C494.553 161.217 495.366 162.03 496.369 162.03Z" fill="#475577"/>
                        <path d="M490.889 162.03C491.892 162.03 492.705 161.217 492.705 160.214C492.705 159.211 491.892 158.398 490.889 158.398C489.886 158.398 489.072 159.211 489.072 160.214C489.072 161.217 489.886 162.03 490.889 162.03Z" fill="#475577"/>
                        <path d="M485.381 162.03C486.384 162.03 487.197 161.217 487.197 160.214C487.197 159.211 486.384 158.398 485.381 158.398C484.378 158.398 483.564 159.211 483.564 160.214C483.564 161.217 484.378 162.03 485.381 162.03Z" fill="#475577"/>
                        <path d="M479.9 162.03C480.904 162.03 481.717 161.217 481.717 160.214C481.717 159.211 480.904 158.398 479.9 158.398C478.897 158.398 478.084 159.211 478.084 160.214C478.084 161.217 478.897 162.03 479.9 162.03Z" fill="#475577"/>
                        <path d="M474.422 162.03C475.425 162.03 476.238 161.217 476.238 160.214C476.238 159.211 475.425 158.398 474.422 158.398C473.419 158.398 472.605 159.211 472.605 160.214C472.605 161.217 473.419 162.03 474.422 162.03Z" fill="#475577"/>
                        <path d="M468.943 162.03C469.947 162.03 470.76 161.217 470.76 160.214C470.76 159.211 469.947 158.398 468.943 158.398C467.94 158.398 467.127 159.211 467.127 160.214C467.127 161.217 467.94 162.03 468.943 162.03Z" fill="#475577"/>
                        <path d="M463.463 162.03C464.466 162.03 465.279 161.217 465.279 160.214C465.279 159.211 464.466 158.398 463.463 158.398C462.46 158.398 461.646 159.211 461.646 160.214C461.646 161.217 462.46 162.03 463.463 162.03Z" fill="#475577"/>
                        <path d="M457.984 162.03C458.988 162.03 459.801 161.217 459.801 160.214C459.801 159.211 458.988 158.398 457.984 158.398C456.981 158.398 456.168 159.211 456.168 160.214C456.168 161.217 456.981 162.03 457.984 162.03Z" fill="#475577"/>
                        <path d="M471.624 384.669C469.391 385.8 467.128 386.902 465.162 388.42C463.614 389.64 462.274 391.159 460.755 392.379C460.458 389.075 460.577 385.771 461.113 382.496C459.266 386.187 458.075 390.176 457.599 394.284C455.663 395.118 453.549 395.654 451.614 396.547C450.81 396.934 450.065 397.35 449.321 397.857C448.993 394.85 448.278 391.903 447.236 389.105C447.117 393.153 446.521 397.202 445.449 401.101C440.953 405.567 437.231 406.519 431.484 413.693C431.424 408.841 431.662 403.959 432.139 399.137C432.496 395.177 433.032 391.188 434.253 387.408C436.427 385.205 439.107 383.508 442.025 382.526C440.209 382.169 438.303 382.109 436.457 382.317C436.457 382.288 436.486 382.258 436.486 382.228C438.809 378.06 442.799 375.024 447.385 373.714C450.154 372.94 453.37 372.137 455.634 371.958C453.698 370.827 451.554 370.053 449.35 369.696C449.559 369.576 449.738 369.487 449.946 369.368C456.527 365.885 464.031 364.426 471.475 364.456C473.53 364.456 475.585 364.575 477.58 365.022C479.635 365.498 481.57 366.272 483.446 367.195C484.578 367.761 487.496 369.993 487.496 369.993C487.496 369.993 481.957 379.4 471.624 384.669Z" fill="#A2CDB7"/>
                        <path d="M496.46 413.961C496.192 413.961 495.983 413.753 495.953 413.485C495.566 402.441 494.107 391.367 491.636 380.561C490.832 377.108 489.76 373.208 486.99 370.827C484.727 368.892 481.422 367.999 477.134 368.147C469.659 368.415 461.798 371.482 455.009 376.78C449.321 381.216 444.17 387.229 439.316 395.148C439.167 395.386 438.869 395.445 438.631 395.326C438.393 395.177 438.333 394.88 438.452 394.641C443.365 386.634 448.577 380.531 454.383 376.006C461.351 370.588 469.391 367.433 477.104 367.165C481.66 367.016 485.203 367.999 487.645 370.082C490.653 372.642 491.784 376.721 492.618 380.353C495.12 391.188 496.579 402.322 496.966 413.455C496.966 413.693 496.757 413.931 496.46 413.961Z" fill="#91B8A4"/>
                        <path d="M488.24 344.035C488.24 344.035 467.961 338.766 463.107 334.568C465.757 332.961 468.646 331.8 471.653 331.085C466.293 327.216 459.712 325.072 453.102 324.983C452.298 324.149 451.464 323.316 450.66 322.482C448.724 320.488 446.729 318.493 444.466 316.945C448.01 315.903 451.643 315.189 455.335 314.832C451.672 313.343 447.563 313.611 443.602 313.611C440.327 313.611 436.873 313.373 434.014 311.885C434.014 311.885 434.014 311.885 433.984 311.885C431.9 310.337 430.351 308.193 428.594 306.258C426.629 304.115 424.098 302.121 421.18 302.031C430.351 299.382 440.178 299.174 449.499 301.228C453.429 303.192 456.943 306.05 459.653 309.533C458.64 307.598 457.836 305.574 457.211 303.49C460.338 304.651 463.375 306.08 466.264 307.777C467.782 309.831 468.884 312.212 469.956 314.564C470.909 316.648 471.862 318.702 472.815 320.786C472.666 317.243 471.862 313.76 470.462 310.515C470.671 310.664 470.879 310.813 471.088 310.962C473.202 312.51 479.098 317.719 485.589 331.502C488.24 337.188 488.24 344.035 488.24 344.035Z" fill="#A2CDB7"/>
                        <path d="M502.95 409.198C502.861 409.198 502.742 409.168 502.653 409.109C502.295 408.841 502.266 408.335 502.176 405.894C501.968 399.226 501.372 381.513 491.724 353.322C484.071 330.937 467.455 319.238 449.678 308.312C449.439 308.164 449.38 307.866 449.499 307.628C449.648 307.39 449.946 307.33 450.184 307.449C468.14 318.493 484.875 330.282 492.647 352.995C502.325 381.305 502.921 399.136 503.159 405.864C503.189 407.055 503.218 408.097 503.308 408.394C503.457 408.573 503.457 408.811 503.308 408.99C503.248 409.109 503.099 409.198 502.95 409.198Z" fill="#91B8A4"/>
                        <path d="M587.4 345.762C583.202 342.16 577.782 339.987 572.243 339.748C575.966 340.79 579.39 342.844 582.13 345.583C582.457 345.911 582.844 346.506 583.321 347.161C577.484 349.155 571.469 351.269 566.109 353.263C556.58 346.744 551.22 347.518 549.731 347.042C554.228 349.096 558.069 351.864 561.404 355.288C560.213 355.764 559.052 356.24 557.95 356.687C553.037 358.711 547.468 357.907 543.21 354.752C541.9 353.769 540.619 353.263 539.339 353.948C528.291 359.961 531.15 353.948 523.914 356.3C523.02 349.126 533.353 340.761 538.386 337.397C559.409 323.495 588.979 323.971 609.525 338.528C609.376 338.558 599.311 341.743 587.4 345.762Z" fill="#A2CDB7"/>
                        <path d="M517.273 414.199C517.035 414.199 516.827 414.021 516.767 413.783C514.772 399.553 514.653 387.051 516.41 376.661C518.077 366.927 521.412 358.741 526.385 352.281C534.634 341.564 547.23 335.313 564.918 333.169C565.186 333.14 565.454 333.318 565.484 333.616C565.514 333.884 565.335 334.152 565.037 334.182C547.647 336.295 535.259 342.398 527.189 352.906C522.336 359.247 519.03 367.284 517.392 376.84C515.636 387.14 515.755 399.524 517.75 413.664C517.78 413.931 517.601 414.199 517.333 414.229C517.303 414.199 517.303 414.199 517.273 414.199Z" fill="#91B8A4"/>
                        <path d="M518.227 321.411C520.579 314.356 524.659 308.015 529.185 302.121C546.277 279.794 570.606 263.094 597.585 255.116C590.796 261.903 578.17 278.633 577.544 279.02C576.77 279.467 563.281 280.985 557.712 282.801C562.804 282.86 568.283 282.384 573.792 283.099C570.427 290.838 559.231 300.483 559.231 300.483C559.231 300.483 550.387 301.912 546.069 303.222C549.047 303.52 551.906 304.026 555.687 304.502C554.318 306.586 549.106 313.373 548.154 313.701C540.649 316.261 532.609 319.386 527.22 324.626C533.056 322.185 538.744 322.095 543.508 321.321C542.913 321.411 533.86 334.122 528.053 338.617C525.612 340.492 519.209 343.499 519.209 343.499C519.209 343.499 514.355 333.02 518.227 321.411Z" fill="#A2CDB7"/>
                        <path d="M505.898 412.86C505.868 412.86 505.839 412.86 505.809 412.86C505.541 412.8 505.362 412.532 505.422 412.264C507.595 401.935 509.68 391.813 511.437 381.632C512.032 378.179 512.628 374.637 513.194 371.243C516.678 350.048 520.311 328.138 531.269 309.503C535.378 302.508 540.649 295.691 547.855 288.04C548.034 287.832 548.362 287.832 548.57 288.01C548.778 288.189 548.778 288.516 548.6 288.725C541.453 296.316 536.212 303.103 532.162 310.009C521.293 328.496 517.72 350.316 514.236 371.422C513.67 374.845 513.075 378.388 512.479 381.841C510.692 392.022 508.608 402.173 506.464 412.502C506.345 412.711 506.136 412.86 505.898 412.86Z" fill="#91B8A4"/>
                        <path d="M511.497 302.299C515.934 298.697 523.349 296.018 523.528 296.048C523.081 304.205 522.098 312.331 520.58 320.369C519.508 326.174 517.929 331.949 514.415 336.92C510.753 342.16 507.418 337.843 504.499 334.271C496.578 324.596 493.184 312.689 494.018 300.573C494.018 300.454 494.047 300.305 494.047 300.186C497.799 303.401 501.283 306.973 504.351 310.843C503.755 308.342 503.874 303.341 495.387 289.41C496.37 283.664 497.74 277.889 499.229 272.233C502.713 273.454 506.465 278.038 506.703 279.348C505.72 275.18 504.738 271.013 503.815 266.845C503.338 264.732 503.01 262.469 502.564 260.237C504.41 254.938 515.994 234.397 522.694 229.962C519.299 241.661 521.324 253.896 522.664 265.893C521.562 267.054 515.368 268.066 513.82 276.014C514.296 273.573 522.188 270.149 523.14 270.626C523.26 271.816 523.349 273.007 523.408 274.228C523.766 280.241 523.825 286.284 523.617 292.297C522.962 292.446 522.336 292.684 521.741 292.952C517.453 294.768 513.731 298.132 511.497 302.299Z" fill="#A2CDB7"/>
                        <path d="M513.433 417.117C513.165 417.117 512.957 416.938 512.927 416.67C509.175 378.596 507.745 339.867 508.609 301.615C508.996 284.2 509.889 265.744 515.905 248.537C515.994 248.27 516.292 248.15 516.53 248.24C516.798 248.329 516.917 248.627 516.828 248.865C510.872 265.952 510.009 284.289 509.592 301.645C508.728 339.867 510.157 378.537 513.909 416.551C513.939 416.819 513.731 417.057 513.463 417.087C513.463 417.117 513.433 417.117 513.433 417.117Z" fill="#91B8A4"/>
                        <path d="M535.199 408.662L534.127 419.2L534.008 420.421L528.559 473.588H483.564L478.145 420.421L478.026 419.2L476.924 408.662H535.199Z" fill="white"/>
                        <path d="M534.127 419.2L534.008 420.421H478.144L478.025 419.2H534.127Z" fill="#E1E7F7"/>
                        <path d="M33.3214 234.487C33.0534 234.487 32.8152 234.398 32.6067 234.189C32.2196 233.802 32.2196 233.177 32.6067 232.76L53.9575 211.416C54.3446 211.029 54.97 211.029 55.3869 211.416C55.774 211.803 55.774 212.428 55.3869 212.845L34.0361 234.189C33.8276 234.368 33.5894 234.487 33.3214 234.487Z" fill="#E1E7F7"/>
                        <path d="M54.6722 234.487C54.4042 234.487 54.166 234.398 53.9575 234.189L32.6067 212.845C32.2196 212.458 32.2196 211.833 32.6067 211.416C32.9939 211.029 33.6192 211.029 34.0361 211.416L55.3869 232.76C55.774 233.147 55.774 233.772 55.3869 234.189C55.1784 234.368 54.9402 234.487 54.6722 234.487Z" fill="#E1E7F7"/>
                        <path d="M543.925 94.3664C543.657 94.3664 543.419 94.2771 543.21 94.0687C542.823 93.6817 542.823 93.0566 543.21 92.6398L561.256 74.6001C561.643 74.2131 562.268 74.2131 562.685 74.6001C563.072 74.987 563.072 75.6122 562.685 76.0289L544.64 94.0687C544.461 94.2771 544.193 94.3664 543.925 94.3664Z" fill="#E1E7F7"/>
                        <path d="M561.97 94.3664C561.702 94.3664 561.464 94.2771 561.256 94.0687L543.21 76.0289C542.823 75.642 542.823 75.0168 543.21 74.6001C543.597 74.2131 544.223 74.2131 544.64 74.6001L562.685 92.6398C563.072 93.0268 563.072 93.6519 562.685 94.0687C562.477 94.2771 562.238 94.3664 561.97 94.3664Z" fill="#E1E7F7"/>
                        <path d="M109.107 29.5005C108.839 29.5005 108.6 29.4112 108.392 29.2028C108.005 28.8158 108.005 28.1907 108.392 27.7739L120.124 16.0749C120.512 15.6879 121.137 15.6879 121.554 16.0749C121.941 16.4619 121.941 17.087 121.554 17.5038L109.821 29.2326C109.643 29.4112 109.375 29.5005 109.107 29.5005Z" fill="#E1E7F7"/>
                        <path d="M120.839 29.5005C120.571 29.5005 120.333 29.4112 120.124 29.2028L108.392 17.474C108.005 17.087 108.005 16.4619 108.392 16.0451C108.779 15.6581 109.404 15.6581 109.821 16.0451L121.554 27.7739C121.941 28.1609 121.941 28.7861 121.554 29.2028C121.345 29.4112 121.107 29.5005 120.839 29.5005Z" fill="#E1E7F7"/>
                        <path d="M230.957 71.2361H200.375C189.179 71.2361 180.037 62.1269 180.037 50.9042V20.3319C180.037 9.13894 189.149 0 200.375 0H230.987C242.184 0 251.326 9.10917 251.326 20.3319V50.9042C251.296 62.0972 242.184 71.2361 230.957 71.2361ZM200.375 1.99449C190.281 1.99449 182.062 10.2106 182.062 20.3021V50.9042C182.062 60.9957 190.281 69.2119 200.375 69.2119H230.987C241.082 69.2119 249.301 60.9957 249.301 50.9042V20.3319C249.301 10.2404 241.082 2.02426 230.987 2.02426H200.375V1.99449Z" fill="#E1E7F7"/>
                        <path d="M215.682 59.1203C202.729 59.1203 192.188 48.5822 192.188 35.6329C192.188 22.6836 202.729 12.1455 215.682 12.1455C228.636 12.1455 239.177 22.6836 239.177 35.6329C239.177 48.5822 228.636 59.1203 215.682 59.1203ZM215.682 14.1102C203.831 14.1102 194.183 23.7552 194.183 35.6031C194.183 47.451 203.831 57.096 215.682 57.096C227.534 57.096 237.182 47.451 237.182 35.6031C237.182 23.7552 227.534 14.1102 215.682 14.1102Z" fill="#E1E7F7"/>
                        <path d="M199.81 52.988C199.542 52.988 199.303 52.8987 199.095 52.6903C198.708 52.3033 198.708 51.6782 199.095 51.2614L231.106 19.29C231.493 18.903 232.119 18.903 232.536 19.29C232.923 19.677 232.923 20.3021 232.536 20.7189L200.524 52.6903C200.346 52.8689 200.078 52.988 199.81 52.988Z" fill="#E1E7F7"/>
                        <path d="M162.141 169.294H1.42944C0.863662 169.294 0.416992 168.847 0.416992 168.282V71.2659C0.416992 63.1391 7.0277 56.5305 15.1571 56.5305H148.354C156.483 56.5305 163.094 63.1391 163.094 71.2659V168.282C163.154 168.847 162.707 169.294 162.141 169.294ZM2.44189 167.299H161.129V71.2659C161.129 64.2406 155.411 58.525 148.384 58.525H15.1869C8.15926 58.525 2.44189 64.2406 2.44189 71.2659V167.299Z" fill="#E1E7F7"/>
                        <path d="M162.588 81.5956H1.01245C0.44667 81.5956 0 81.149 0 80.5834C0 80.0178 0.44667 79.5713 1.01245 79.5713H162.588C163.153 79.5713 163.6 80.0178 163.6 80.5834C163.6 81.149 163.124 81.5956 162.588 81.5956Z" fill="#E1E7F7"/>
                        <path d="M17.837 75.493C14.621 75.493 12.0303 72.8734 12.0303 69.6882C12.0303 66.4732 14.6507 63.8833 17.837 63.8833C21.053 63.8833 23.6437 66.5029 23.6437 69.6882C23.6735 72.8734 21.053 75.493 17.837 75.493ZM17.837 65.848C15.7227 65.848 14.0254 67.5448 14.0254 69.6584C14.0254 71.772 15.7227 73.4688 17.837 73.4688C19.9512 73.4688 21.6486 71.772 21.6486 69.6584C21.6486 67.5448 19.9512 65.848 17.837 65.848Z" fill="#E1E7F7"/>
                        <path d="M32.5469 75.493C29.3309 75.493 26.7402 72.8734 26.7402 69.6882C26.7402 66.4732 29.3607 63.8833 32.5469 63.8833C35.763 63.8833 38.3536 66.5029 38.3536 69.6882C38.3536 72.8734 35.763 75.493 32.5469 75.493ZM32.5469 65.848C30.4327 65.848 28.7354 67.5448 28.7354 69.6584C28.7354 71.772 30.4327 73.4688 32.5469 73.4688C34.6612 73.4688 36.3585 71.772 36.3585 69.6584C36.3585 67.5448 34.6612 65.848 32.5469 65.848Z" fill="#E1E7F7"/>
                        <path d="M47.2579 75.493C44.0419 75.493 41.4512 72.8734 41.4512 69.6882C41.4512 66.4732 44.0716 63.8833 47.2579 63.8833C50.4739 63.8833 53.0646 66.5029 53.0646 69.6882C53.0646 72.8734 50.4441 75.493 47.2579 75.493ZM47.2579 65.848C45.1436 65.848 43.4463 67.5448 43.4463 69.6584C43.4463 71.772 45.1436 73.4688 47.2579 73.4688C49.3721 73.4688 51.0695 71.772 51.0695 69.6584C51.0695 67.5448 49.3423 65.848 47.2579 65.848Z" fill="#E1E7F7"/>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M92.5798 104.964L92.4607 104.845C89.3638 101.719 84.2717 101.719 81.1451 104.845L73.9388 112.049C70.8419 115.145 70.8419 120.235 73.9388 123.361L74.0579 123.48C74.3259 123.748 74.5939 123.986 74.8619 124.194L77.5121 121.545C77.2144 121.366 76.9166 121.158 76.6486 120.89L76.5295 120.771C74.8321 119.074 74.8321 116.335 76.5295 114.639L83.7357 107.435C85.4331 105.738 88.1726 105.738 89.87 107.435L89.9891 107.554C91.6864 109.25 91.6864 111.989 89.9891 113.686L86.7135 116.961C87.2793 118.36 87.5473 119.848 87.5175 121.337L92.55 116.306C95.6767 113.15 95.6767 108.06 92.5798 104.964ZM81.9193 115.353C81.6513 115.085 81.3833 114.847 81.1153 114.639L78.465 117.288C78.7628 117.467 79.0606 117.675 79.3286 117.943L79.4477 118.062C81.145 119.759 81.145 122.497 79.4477 124.194L72.2414 131.398C70.5441 133.095 67.8045 133.095 66.1072 131.398L65.9881 131.279C64.2907 129.582 64.2907 126.844 65.9881 125.147L69.2637 121.872C68.6979 120.473 68.4299 118.985 68.4596 117.496L63.4272 122.527C60.3303 125.653 60.3303 130.714 63.4272 133.839L63.5463 133.958C66.6432 137.084 71.7352 137.084 74.8619 133.958L82.0682 126.754C85.1651 123.658 85.1651 118.568 82.0682 115.442L81.9193 115.353Z" fill="#E1E7F7"/>
                    </svg>
                </div>
                <div class="col-lg-5">
                    <div class="no-page ">
                        <div class="no-page__title">@yield('code')</div>
                        <h2>@yield('title')</h2>
                        <div class="pr-30 mb-3">@yield('message')</div>
                        <div class="d-inline-block mt-40 md:mt-20">
                            <a href="{{ url('/') }}" class="btn btn-primary">{{ __("Go back to homepage") }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('footer')
@endsection
