@extends('layouts.app', ['container_class' => 'container-fluid', 'header_right_menu' => true])
@push('css')
    <link href="{{ asset('themes/bc/dist/frontend/module/space/css/flight.css?_ver=' . config('app.asset_version')) }}" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="{{ asset('libs/ion_rangeslider/css/ion.rangeSlider.min.css') }}" />
    <style type="text/css">
        .bc_topbar,
        .bc_footer {
            display: none
        }
    </style>
@endpush
@section('content')
    <div class="bc_search_tour bc_search_space">
        <h1 class="d-none">
            {{ setting_item_with_lang('flight_page_search_title') }}
        </h1>
        <div class="bc_form_search_map">
            @include('Flight::frontend.layouts.search-map.form-search-map')
        </div>
        <div class="bc_search_map {{ setting_item_with_lang('flight_layout_map_option', false, 'map_left') }}">
            <div class="results_map">
                <div class="map-loading d-none">
                    <div class="st-loader"></div>
                </div>
                <div id="bc_results_map" class="results_map_inner"></div>
            </div>
            <div class="results_item">
                @include('Flight::frontend.layouts.search-map.advance-filter')
                <div class="listing_items">
                    @include('Flight::frontend.layouts.search-map.list-item')
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    {!! App\Helpers\MapEngine::scripts() !!}
    <script>
        var bc_map_data = {
            markers: {!! json_encode($markers) !!}
        };
    </script>
    <script type="text/javascript" src="{{ asset('libs/ion_rangeslider/js/ion.rangeSlider.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('module/space/js/space-map.js?_ver=' . config('app.asset_version')) }}">
    </script>
@endpush
