<?php


namespace Modules\Tracking\Models;


use Custom\Email\Models\Campaign;
use Illuminate\Database\Eloquent\Model;
use Modules\Booking\Models\Service;
use Modules\Tour\Models\Tour;

class TrackingLog extends Model
{

    protected $table = 'tracking_logs';
    protected $fillable = [
        'utm_id',
        'user_id',
        'path_id',
        'event_id',
        'event_sub_name',
        'object_id',
        'device_id',
        'object_model',
        'is_ajax',
        'method',
        'geoip_id',
        'country',
        'browser_lang',
        'client_ip',
        'cpc',
        'vendor_id',
    ];

    public function save(array $options = [])
    {
        $time = time();

        $this->year = date('Y',$time);
        $this->month = date('m',$time);
        $this->day = date('d',$time);
        $this->hour = date('H',$time);
        $this->minute = date('m',$time);

        return parent::save($options); // TODO: Change the autogenerated stub
    }

    public function service()
    {
        $all = get_bookable_services();
        $all['campaign'] = Campaign::class;
        if ($this->object_model and !empty($all[$this->object_model])) {
            return $this->hasOne($all[$this->object_model], 'id', 'object_id');
        }
        return $this->hasOne(Tour::class,'id','object_id');
    }

    public static function search($filters = []){
        $q = parent::query();
        $service = new Service();
        $log = new static();
        if(!empty($filters['vendor_id'])){
            $q->where($log->table.'.vendor_id',$filters['vendor_id']);
        }

        if(!empty($filters['from_date'])){
            $q->where($log->table.'.created_at','>=',$filters['from_date']);
        }
        if(!empty($filters['to_date'])){
            $q->where($log->table.'.created_at','<=',$filters['to_date']);
        }

        return $q;
    }

    public function event(){
        return $this->hasOne(TrackingEvent::class,'id','event_id');
    }
}
