@extends('admin.layouts.app')

@section('content')
    <form action="{{ route('property.admin.store', ['id' => $row->id ? $row->id : '-1', 'lang' => request()->query('lang')]) }}"
        method="post">
        @csrf
        <div class="container-fluid">
            <div class="d-flex justify-content-between mb20">
                <div class="">
                    <h1 class="title-bar">{{ $row->id ? __('Edit: ') . $row->title : __('Add new property') }}</h1>
                    @if ($row->slug)
                        <p class="item-url-demo">{{ __('Permalink') }}: {{ url('property') }}/
                            <a href="#" class="open-edit-input" data-name="slug">{{ $row->slug }}</a>
                        </p>
                    @endif
                </div>
                <div class="">
                    @if ($row->slug)
                        <a class="btn btn-primary btn-sm" href="{{ $row->getDetailUrl(request()->query('lang')) }}"
                            target="_blank">{{ __('View Property') }}</a>
                    @endif
                </div>
            </div>
            @include('admin.message')
            @if ($row->id)
                @include('Language::admin.navigation')
            @endif
            <div class="lang-content-box">
                <div class="row">
                    <div class="col-md-9">
                        @include('Property::admin.property.content')
                        @php do_action(\Modules\Property\Hook::FORM_AFTER_CONTENT,$row) @endphp

                        @include('Property::admin.property.location')
                        @include('Core::admin/seo-meta/seo-meta')
                    </div>
                    <div class="col-md-3">
                        <div class="panel">
                            <div class="panel-title"><strong>{{ __('Publish') }}</strong></div>
                            <div class="panel-body">
                                @if (is_default_lang())
                                    <div>
                                        <label class="cursor-pointer">
                                            <input @if ($row->status == 'publish') checked @endif type="radio"
                                                name="status" value="publish"> {{ __('Publish') }}
                                        </label>
                                    </div>
                                    <div>
                                        <label class="cursor-pointer">
                                            <input @if ($row->status == 'draft') checked @endif type="radio"
                                                name="status" value="draft"> {{ __('Draft') }}
                                        </label>
                                    </div>
                                @endif
                                <div class="text-right">
                                    <button class="btn btn-primary" type="submit">
                                        <i class="fa fa-save"></i> {{ __('Save Changes') }}</button>
                                </div>
                            </div>
                        </div>
                        @if (is_default_lang())
                            <div class="panel">
                                <div class="panel-title"><strong>{{ __('Category') }}</strong></div>
                                <div class="panel-body">
                                    <div class="form-group">
                                        <div class="">
                                            <select name="category_id" class="form-control">
                                                <option value="">{{ __('-- Please Select --') }}</option>
                                                <?php
                                                $traverse = function ($categories, $prefix = '') use (&$traverse, $row) {
                                                    foreach ($categories as $category) {
                                                        $selected = '';
                                                        if ($row->category_id == $category->id) {
                                                            $selected = 'selected';
                                                        }
                                                        printf("<option value='%s' %s>%s</option>", $category->id, $selected, $prefix . ' ' . $category->name);
                                                        $traverse($category->children, $prefix . '-');
                                                    }
                                                };
                                                $traverse($property_category);
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        @if (is_default_lang())
                            <div class="panel">
                                <div class="panel-title"><strong>{{ __('Property type') }}</strong></div>
                                <div class="panel-body">
                                    <div class="form-group">
                                        <div>
                                            <label class="cursor-pointer">
                                                <input type="radio" name="property_type" id="property_type_buy"
                                                    value="1" @if (old('property_type', $row->property_type ?? 0) == 1) checked @endif>
                                                {{ __('For buy') }}
                                            </label>
                                        </div>
                                        <div>
                                            <label class="cursor-pointer">
                                                <input type="radio" name="property_type" id="property_type_rent"
                                                    value="2" @if (old('property_type', $row->property_type ?? 0) == 2) checked @endif>
                                                {{ __('For rent') }}
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (is_default_lang())
                            <div class="panel">
                                <div class="panel-title"><strong>{{ __('Availability') }}</strong></div>
                                <div class="panel-body">
                                    <div class="form-group">
                                        <label>{{ __('Property Featured') }}</label>
                                        <br>
                                        <label>
                                            <input type="checkbox" name="is_featured"
                                                @if ($row->is_featured) checked @endif value="1">
                                            {{ __('Enable featured') }}
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="panel">
                                <div class="panel-title"><strong>{{ __('Sold') }}</strong></div>
                                <div class="panel-body">
                                    <div class="form-switch">
                                        <label>
                                            <input type="checkbox" name="is_sold" value="1"
                                                @if ($row->is_sold) checked @endif> {{ __('Sold Out') }}
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="panel">
                                <div class="panel-title"><strong>{{ __('Feature Image') }}</strong></div>
                                <div class="panel-body">
                                    <div class="form-group image-feature">
                                        {!! \Modules\Media\Helpers\FileHelper::fieldUpload('image_id', $row->image_id) !!}
                                    </div>
                                </div>
                            </div>
                            {{-- @include('Property::admin/property/ical') --}}
                        @endif

                        @if (is_default_lang())
                            <div class="panel">
                                <div class="panel-title"><strong>{{ __('Author Setting') }}</strong></div>
                                <div class="panel-body">
                                    <div class="form-group">
                                        <?php
                                        $user = !empty($row->author_id) ? \Modules\User\Models\User::find($row->author_id) : false;
                                        \App\Helpers\AdminForm::select2(
                                            'author_id',
                                            [
                                                'configs' => [
                                                    'ajax' => [
                                                        'url' => url('/admin/module/user/getForSelect2'),
                                                        'dataType' => 'json',
                                                    ],
                                                    'allowClear' => true,
                                                    'placeholder' => __('-- Select User --'),
                                                ],
                                            ],
                                            !empty($user->id) ? [$user->id, $user->getDisplayName() . ' (#' . $user->id . ')'] : false,
                                        );
                                        ?>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @include('Property::admin.property.attributes')
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
@push('js')
    {!! App\Helpers\MapEngine::scripts() !!}
    <script>
        jQuery(function($) {
            new BCMapEngine('map_content', {
                disableScripts: true,
                fitBounds: true,
                center: [{{ $row->map_lat ?? '51.505' }}, {{ $row->map_lng ?? '-0.09' }}],
                zoom: {{ $row->map_zoom ?? '8' }},
                ready: function(engineMap) {
                    @if ($row->map_lat && $row->map_lng)
                        engineMap.addMarker([{{ $row->map_lat }}, {{ $row->map_lng }}], {
                            icon_options: {},
                        });
                    @endif
                    engineMap.on('click', function(dataLatLng) {
                        engineMap.clearMarkers();
                        engineMap.addMarker(dataLatLng, {
                            icon_options: {},
                        });
                        $('input[name=map_lat]').attr('value', dataLatLng[0]);
                        $('input[name=map_lng]').attr('value', dataLatLng[1]);
                    });
                    engineMap.on('zoom_changed', function(zoom) {
                        $('input[name=map_zoom]').attr('value', zoom);
                    });
                    engineMap.searchBox($('.bc_searchbox'), function(dataLatLng) {
                        engineMap.clearMarkers();
                        engineMap.addMarker(dataLatLng, {
                            icon_options: {},
                        });
                        $('input[name=map_lat]').attr('value', dataLatLng[0]);
                        $('input[name=map_lng]').attr('value', dataLatLng[1]);
                    });
                },
            });
        });
    </script>
@endpush
