<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAgenciesTable extends Migration
{
    protected $tbl = 'bc_agencies';
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable($this->tbl)) {
            return;
        }
        Schema::create($this->tbl, function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('mobile', 25)->nullable();
            $table->string('fax', 50)->nullable();
            $table->string('office', 255)->nullable();
            $table->string('status',50)->nullable();
            $table->string('slug',255)->nullable();
            $table->decimal('review_score',4,2)->nullable();
            $table->integer('image_id')->nullable();
            $table->integer('banner_image_id')->nullable();
            $table->integer('author_id')->nullable();
            $table->integer('create_user')->nullable();
            $table->integer('update_user')->nullable();
            $table->text('social')->nullable();
            $table->text('content')->nullable();

            //lang
            $table->bigInteger('origin_id')->nullable();
            $table->string('lang',10)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        if (!Schema::hasTable('bc_agencies_translations')) {
            Schema::create('bc_agencies_translations', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('origin_id')->unsigned();
                $table->string('locale')->index();

                $table->string('name', 255)->nullable();
                $table->text('content')->nullable();

                $table->bigInteger('create_user')->nullable();
                $table->bigInteger('update_user')->nullable();

                $table->unique(['origin_id', 'locale']);

                $table->softDeletes();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists($this->tbl);
    }
}
