<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('bc_attrs')) {
            Schema::create('bc_attrs', function (Blueprint $table) {
                $table->bigIncrements('id');

                $table->string('name', 255)->nullable();
                $table->string('slug', 255)->nullable();
                $table->string('service', 50)->nullable();
                $table->tinyInteger('hide_in_filter_search')->nullable();
                $table->smallInteger('position')->nullable();
                $table->string('display_type', 255)->nullable();
                $table->tinyInteger('hide_in_single')->nullable();

                $table->bigInteger('create_user')->nullable();
                $table->bigInteger('update_user')->nullable();
                $table->softDeletes();
                $table->timestamps();
            });

            Schema::create('bc_terms', function (Blueprint $table) {
                $table->bigIncrements('id');

                $table->string('name', 255)->nullable();
                $table->text('content')->nullable();
                $table->integer('attr_id')->nullable();
                $table->string('slug', 255)->nullable();

                $table->bigInteger('create_user')->nullable();
                $table->bigInteger('update_user')->nullable();
                $table->integer('image_id')->nullable();
                $table->string('icon')->nullable();

                //Languages
                $table->bigInteger('origin_id')->nullable();
                $table->string('lang', 10)->nullable();

                $table->softDeletes();
                $table->timestamps();
            });
            Schema::create('bc_attrs_translations', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->bigInteger('origin_id')->nullable();
                $table->string('locale', 10)->nullable();

                $table->string('name', 255)->nullable();

                $table->bigInteger('create_user')->nullable();
                $table->bigInteger('update_user')->nullable();
                $table->unique(['origin_id', 'locale']);
                $table->timestamps();
            });

            Schema::create('bc_terms_translations', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->bigInteger('origin_id')->nullable();
                $table->string('locale', 10)->nullable();

                $table->string('name', 255)->nullable();
                $table->text('content')->nullable();

                $table->bigInteger('create_user')->nullable();
                $table->bigInteger('update_user')->nullable();
                $table->unique(['origin_id', 'locale']);
                $table->timestamps();
            });
        }
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bc_attrs');
        Schema::dropIfExists('bc_terms');
        Schema::dropIfExists('bc_attrs_translations');
        Schema::dropIfExists('bc_terms_translations');
    }
};
